
//Discrete Probability Distributions
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//(i)Binomial
deff('[CC]=C(n,r)','CC=gamma(n+1)./(gamma(r+1).*gamma(n-r+1))')    //Binomial coefficient
deff('[bb]=b(x,n,p)','bb=C(n,x).*p.^x.*(1-p).^(n-x)')              //Binomial pmf
deff('[BB]=B(x,n,p)','BB=sum(b([0:1:x],n,p))')                     //Binomial CDF
n=10;
p=0.25;

//P(X=2)
p=b(2,10,0.25)
disp(p)

//pmf
b10=[];
for j=0:10,b10=[b10 b(j,10,0.25)]; end;
disp(b10)

//CDF
x=2
p=B(2,10,0.25)
disp(p)

//P(X>2)=1-P(X<=2)
p=1-B(2,10,0.25)
disp(p)

//List of values of CDF
B10=[];
for j=0:10,B10=[B10 B(j,10,0.25)]; end;
disp(B10)

//(ii)Geometric
deff('[gg]=g(x,p)','gg=p.*(1-p).^(x-1)')                          //Geometric pmf
deff('[GG]=G(x,p)','GG=sum(g([1:x],p))')                          //Geometric CDF

//P(X=3) and P(X=5),p=0.50
p=g(3,0.50)
disp(p)
p=g(5,0.50)
disp(p)

//Calculate vector of values of pmf
disp(g([1:10],0.5))

//P(X6) ,P(X3) ,P(X1)
p1=G(6,0.5)
disp(p1)
p2=G(3,0.5)
disp(p2)
p3=G(1,0.5)
disp(p3)

//Vector of values of CDF
G10=[];
for j=1:10, G10=[G10 G(j,0.5)]; end;
disp(G10)

//(iii)Hypergeometric
deff('[hh]=h(x,N,n,a)','hh=C(a,x).*C(N-a,n-x)./C(N,n)')          //Hypergeometric pmf
deff('[HH]=H(x,N,n,a)','HH=sum(h([0:1:x],N,n,a))')               //Hypergeometric CDF
N=100;
n=20;
a=35;

//P(X=12)
p=h(12,N,n,a)
disp(p)

//Cumulative distribution ,x=12
cd_x=H(12,N,n,a)
disp(cd_x)

//Generate vector of values of pdf
disp(h([0:20],N,n,a))

//Generate vector of values of CDF
H10=[];
for j=1:10,H10=[H10 h(j,N,n,a)]; end;
disp(H10)
